import { ForwardedRef, forwardRef } from 'react';
import clsx from 'clsx';

import type { IListBoxItemProps } from './list-box-item.types';

// atomic:component:list-box-item
// atomic:component:list-box-item:type.forward-ref
export const ListBoxItem = forwardRef(
    (
        {
            id,
            testId,
            className,
            children,
            selected,
            startNode,
            reserveStartNodeSpace,
            role = 'option',
            disabled,
            ...props
        }: IListBoxItemProps,
        ref: ForwardedRef<HTMLButtonElement>,
    ) => {
        return (
            <button
                role={role}
                disabled={disabled}
                aria-disabled={disabled}
                aria-selected={selected}
                ref={ref}
                id={id}
                data-qa={testId}
                className={clsx(
                    'transition flex items-center px-3 py-1.5 outline-none border-none w-full',
                    disabled
                        ? 'text-text-secondary bg-control-disabled'
                        : 'text-text-primary hover:bg-highlight/90 focus:bg-highlight/90',
                    className,
                )}
                {...props}
            >
                {(startNode || reserveStartNodeSpace) && (
                    <div className="mr-3 w-4 h-4 inline-flex items-center justify-center">
                        {startNode || '\u00A0'}
                    </div>
                )}
                {children}
            </button>
        );
    },
);
