import { cloneElement, forwardRef, useState } from 'react';
import { createPortal } from 'react-dom';

import { useForkChildrenRef, useUniversalLayoutEffect } from '../../hooks';
import { setRef } from '../../hooks/use-fork-ref';
import type { PortalProps } from './portal.d';

export const Portal = forwardRef(({ children, targetNode, disablePortal }: PortalProps, ref) => {
    const [mountNode, setMountNode] = useState<HTMLElement | null>(null);
    const forkRef = useForkChildrenRef(children, ref);

    useUniversalLayoutEffect(() => {
        if (!disablePortal) {
            setMountNode(targetNode ?? document.body);
        }
    }, [targetNode, disablePortal]);

    useUniversalLayoutEffect(() => {
        if (mountNode && !disablePortal) {
            setRef(ref, mountNode);

            return () => setRef(ref, null);
        }

        return undefined;
    }, [mountNode, disablePortal]);

    if (disablePortal) {
        return cloneElement(children, {
            ref: forkRef,
        });
    }

    return mountNode ? createPortal(children, mountNode) : mountNode;
});
