import { ForwardedRef, forwardRef } from 'react';
import clsx from 'clsx';
import type { IRangeControlProps } from './range-control.types';

const classNameBySize = {
    sm: 'w-6 h-6',
    md: 'w-8 h-8',
};

// atomic:component:range-control
// atomic:component:range-control:type.forward-ref
export const RangeControl = forwardRef(
    (
        {
            id,
            testId,
            className,
            disabled,
            active,
            size,
            min,
            max,
            value,
            ...props
        }: IRangeControlProps,
        ref: ForwardedRef<HTMLButtonElement>,
    ) => (
        <button
            {...props}
            id={id}
            ref={ref}
            role="slider"
            data-qa={testId}
            disabled={disabled}
            aria-valuemin={min}
            aria-valuemax={max}
            aria-valuenow={value}
            className={clsx(
                'bg-white border-4 rounded-full transition',
                disabled
                    ? 'border-text-disabled'
                    : [
                          'border-text-primary',
                          active
                              ? 'bg-text-primary scale-95'
                              : 'hover:bg-text-primary active:bg-text-primary active:scale-95',
                      ],
                classNameBySize[size],
                className,
            )}
        />
    ),
);
