import { ISharedHtmlAtomProps, PropsOf } from '@yandex-travel/ui/types';

export interface IRangeControlProps
    extends ISharedHtmlAtomProps,
        Pick<
            PropsOf<'button'>,
            'style' | 'onKeyDown' | 'onPointerDown' | 'onPointerMove' | 'onPointerUp'
        > {
    disabled?: boolean;
    active?: boolean;
    size: TRangeControlSize;
    min: number;
    max: number;
    value: number;
}

export type TRangeControlSize = 'sm' | 'md';
