import { Meta, Story } from '@storybook/react/types-6-0';

import { TextSkeleton } from './text-skeleton';
import type { ITextSkeletonProps, TTextSkeletonType } from './text-skeleton.d';

const csf: Meta = {
    title: 'atoms/TextSkeleton',
    component: TextSkeleton,
};
const typographies: TTextSkeletonType[] = ['h1', 'h2', 'h3', 'm', 's', 'xs'];

export const gallery: Story<ITextSkeletonProps> = args => (
    <>
        {typographies.map(type => (
            <TextSkeleton {...args} type={type} className="mb-4 block" key={type} />
        ))}
    </>
);

gallery.storyName = 'Все варианты';

const Template: Story<ITextSkeletonProps> = args => <TextSkeleton {...args} />;

export const playground = Template.bind({});

playground.storyName = 'Песочница';
playground.args = {
    type: 'm',
    width: 240,
    animated: true,
};

export default csf;
