import { memo } from 'react';
import clsx from 'clsx';

import type { ITextSkeletonProps } from './text-skeleton.d';

export const TextSkeleton = memo(
    ({ type, className, animated, width = 100 }: ITextSkeletonProps) => (
        <span
            className={clsx(
                'flex items-center overflow-hidden',
                // TODO Сделать класс skeleton, использовать before:skeleton
                'before:content-[" "] before:block before:bg-control-disabled',
                'before:w-full before:h-[1em] before:rounded-full',
                animated && 'before:animate-pulse',
                type && sizes[type],
                className,
            )}
            style={{ width }}
        />
    ),
);

const sizes = {
    h1: 'h-9.5 text-xxl',
    h2: 'h-6.5 text-xl',
    h3: 'h-5.5 text-l',
    m: 'h-5 text-m',
    s: 'h-4.5 text-s',
    xs: 'h-3.5 text-xs',
};
