import { Meta, Story } from '@storybook/react/types-6-0';

import { Text } from './text';
import type { TextProps } from './text.types';

const csf: Meta = {
    title: 'atoms/Text',
    component: Text,
};

const typographies = [
    ['xxl', 'Заголовок <h1>', ['bold'], ['xxl']],
    ['xl', 'Заголовок <h2>', ['bold'], ['xl']],
    ['lg', 'Заголовок <h3>', ['regular', 'medium', 'bold'], ['lg']],
    ['md', 'Большой текст', ['regular', 'medium', 'bold'], ['md']],
    ['sm', 'Основной текст', ['regular', 'medium', 'bold'], ['sm', 'xs']],
    ['xs', 'Пояснительный текст', ['regular'], ['xxs']],
] as const;

export const gallery: Story<{}> = () => (
    <table className="text-left">
        <thead>
            <tr>
                <th className="p-4">Пример</th>
                <th className="p-4">Размер</th>
                <th className="p-4">Начертание</th>
                <th className="p-4">Интерлиньяж</th>
            </tr>
        </thead>
        <tbody>
            {typographies.map(([type, label, weights, leadings]) => (
                <tr key={type} className="border-b border-grey-light">
                    <td className="p-4">
                        <div className="flex flex-col gap-2 items-start">
                            {weights.map(weight => (
                                <Text key={weight} size={type} weight={weight}>
                                    {label}
                                </Text>
                            ))}
                        </div>
                    </td>
                    <td className="p-4">{type}</td>
                    <td className="p-4">
                        <div className="flex flex-col gap-2 items-start">
                            {weights.map(weight => (
                                <Text key={weight} weight={weight} size="sm">
                                    {weight}
                                </Text>
                            ))}
                        </div>
                    </td>
                    <td className="p-4">
                        <div className="flex flex-col gap-2 items-start">
                            {leadings.map(leading => (
                                <Text
                                    key={leading}
                                    leading={leading as any}
                                    size="sm"
                                    className="bg-fill-warning-highlight px-2"
                                >
                                    {leading}
                                </Text>
                            ))}
                        </div>
                    </td>
                </tr>
            ))}
        </tbody>
    </table>
);

gallery.storyName = 'Gallery';
gallery.args = {};

const Template: Story<TextProps<'span', any>> = args => <Text {...args} />;

export const sandbox = Template.bind({});

sandbox.storyName = 'Sandbox';
sandbox.args = {};

export default csf;
