import { ReactElement, ReactNode } from 'react';

import { ISharedHtmlAtomProps, PolymorphicProps } from '../../types';

export type TextProps<C, Size extends TextSize> = PolymorphicProps<C, SharedTextProps<Size>>;
export type TextComponent = (<C = 'span', Size extends TextSize = 'sm'>(
    props: TextProps<C, Size>,
) => ReactElement) & {
    displayName?: string;
};

export interface SharedTextProps<Size extends TextSize> extends ISharedHtmlAtomProps {
    children?: ReactNode;
    size?: Size;
    weight?: TextWeightBySize[Size];
    leading?: TextLeadingBySize[Size];
}

export type TextSize = keyof TextLeadingBySize;
export type TextWeight = TextWeightBySize[keyof TextWeightBySize];
export type TextLeading = TextLeadingBySize[keyof TextLeadingBySize];

export interface TextWeightBySize {
    xxl: 'bold';
    xl: 'bold';
    lg: 'regular' | 'medium' | 'bold';
    md: 'regular' | 'medium' | 'bold';
    sm: 'regular' | 'medium' | 'bold';
    xs: 'regular';
}

export interface TextLeadingBySize {
    xxl: 'xxl';
    xl: 'xl';
    lg: 'lg';
    md: 'md';
    sm: 'sm' | 'xs';
    xs: 'xxs';
}
