import React from 'react';

export interface UseDraggableParams {
    onStart?(event: React.PointerEvent): void;
    onMove?(movement: DraggablePayload, event: React.PointerEvent): void;
    onEnd?(event: React.PointerEvent): void;
}

export interface DraggablePayload {
    diff: DraggableMovement;
    full: DraggableMovement;
}

export interface DraggableMovement {
    x: number;
    y: number;
}

export interface UseDraggableResult {
    anchorProps: {
        onPointerDown(event: React.PointerEvent): void;
        onPointerMove(event: React.PointerEvent): void;
        onPointerUp(event: React.PointerEvent): void;
    };
    dragging: boolean;
}
