import type { DraggableMovement, UseDraggableParams, UseDraggableResult } from './use-draggable.d';
import useEventCallback from '../use-event-callback';
import React, { useState } from 'react';

export function useDraggable({
    onEnd,
    onMove,
    onStart,
}: UseDraggableParams = {}): UseDraggableResult {
    const [start, setStart] = useState<DraggableMovement | null>(null);
    const [prev, setPrev] = useState<DraggableMovement | null>(null);
    const dragging = Boolean(start);

    const onPointerDown = useEventCallback((e: React.PointerEvent) => {
        const target = e.currentTarget as HTMLElement;

        target.setPointerCapture(e.pointerId);
        setStart({
            y: e.clientY,
            x: e.clientX,
        });
        onStart?.(e);
    });
    const onPointerMove = useEventCallback((e: React.PointerEvent) => {
        if (start) {
            const next = { y: e.clientY - start.y, x: e.clientX - start.x };
            const diff: DraggableMovement = prev
                ? {
                      x: next.x - prev.x,
                      y: next.y - prev.y,
                  }
                : next;

            setPrev(next);
            onMove?.(
                {
                    full: next,
                    diff,
                },
                e,
            );
        }
    });
    const onPointerUp = useEventCallback((e: React.PointerEvent) => {
        setStart(null);
        setPrev(null);
        onEnd?.(e);
    });

    return {
        dragging,
        anchorProps: {
            onPointerUp,
            onPointerMove,
            onPointerDown,
        },
    };
}
