import { useState } from 'react';

import useUniversalLayoutEffect from '../use-universal-layout-effect';

export function useId(staticId?: string) {
    const [uuid, setUuid] = useState('');

    useUniversalLayoutEffect(() => {
        setUuid(randomId());
    }, []);

    return staticId || uuid;
}

export function randomId() {
    return `uuid-${Math.random().toString(36).slice(2, 11)}`;
}
