/**
 * Функция для расчета позиции элемента БЕЗ УЧЕТА ТРАНСФОРМАЦИЙ
 * Если вам это не важно - используйте element.getBoundingClientRect
 */
export function getElementOffset(element: HTMLElement): IElementOffset {
    let top = 0;
    let left = 0;

    while (element) {
        top += element.offsetTop;
        left += element.offsetLeft;
        element = element.offsetParent as HTMLElement;
    }

    return { top, left };
}

export interface IElementOffset {
    top: number;
    left: number;
}
