import { ReactElement, ReactNode } from 'react';

import { ISharedHtmlAtomProps, PolymorphicProps } from '../../types';

import { SharedTextProps } from '../../atoms/text/text.types';

export type ButtonProps<C, Size extends ButtonSize> = PolymorphicProps<C, SharedButtonProps<Size>>;
export type ButtonComponent = (<C = 'button', Size extends ButtonSize = 'md'>(
    props: ButtonProps<C, Size>,
) => ReactElement) & {
    displayName?: string;
};

export interface SharedButtonProps<Size extends ButtonSize = 'md'>
    extends ISharedHtmlAtomProps,
        Pick<SharedTextProps<Size>, 'leading' | 'weight'> {
    size?: Size;
    textSize?: ButtonTextSizeMap[Size];
    shape?: 'circle';
    theme?: ButtonTheme;
    children?: ReactNode;
    startNode?: ReactElement;
    endNode?: ReactElement;
}

export type ButtonTheme =
    | 'attention'
    | 'secondary'
    | 'outlined'
    | 'primary'
    | 'raised'
    | 'plain'
    | 'plus';

export type ButtonSize = 'sm' | 'md' | 'lg' | 'xl';

export interface ButtonTextSizeMap {
    sm: 'sm';
    md: 'sm' | 'md';
    lg: 'sm' | 'md' | 'lg';
    xl: 'md' | 'lg' | 'xl';
}

export interface ButtonSizeSettings {
    base: string;
    content: {
        default?: string;
        icon?: string;
    };
    icon: {
        base: string;
        left: string;
        right: string;
    };
}
