import clsx from 'clsx';

import type { IFieldLayoutProps } from './field-layout.types';
import Text from '../../atoms/text';

// atomic:component:field-layout
// atomic:component:field-layout:type.function
export function FieldLayout({
    id,
    invalid,
    description,
    label,
    children,
    className,
    testId,
}: IFieldLayoutProps) {
    return (
        <div className={className} data-qa={testId}>
            <Text
                as="label"
                size="sm"
                id={id && `${id}-label`}
                htmlFor={id}
                className="mb-1 text-text-primary block"
            >
                {label}
            </Text>
            {children}
            <Text
                id={id && `${id}-description`}
                size="xs"
                className={clsx('block mt-1', invalid ? 'text-text-alert' : 'text-text-primary')}
            >
                {description || '\u00A0'}
            </Text>
        </div>
    );
}
