import { Meta, Story } from '@storybook/react/types-6-0';

import { Input } from './input';
import type { InputProps, InputSize } from './input.d';

const csf: Meta = {
    title: 'molecules/Input',
    component: Input,
};
const INPUT_SIZES: InputSize[] = ['l', 'm', 's'];

export const sizesAndThemes: Story<InputProps> = args => (
    <table className="text-left">
        <thead>
            <tr>
                <th className="p-4">Размер</th>
                <th className="p-4">Default</th>
                <th className="p-4">Invalid</th>
                <th className="p-4">Disabled</th>
                <th className="p-4">Disabled with value</th>
            </tr>
        </thead>
        <tbody>
            {INPUT_SIZES.map(size => (
                <tr key={size} className="border-b border-grey-light">
                    <td className="p-4">{size}</td>
                    <td className="p-4">
                        <Input placeholder="My placeholder" size={size} {...args} />
                    </td>
                    <td className="p-4">
                        <Input placeholder="My placeholder" invalid size={size} {...args} />
                    </td>
                    <td className="p-4">
                        <Input placeholder="My placeholder" disabled size={size} {...args} />
                    </td>
                    <td className="p-4">
                        <Input
                            placeholder="My placeholder"
                            defaultValue="My value"
                            disabled
                            size={size}
                            {...args}
                        />
                    </td>
                </tr>
            ))}
        </tbody>
    </table>
);

sizesAndThemes.storyName = 'Размеры и темы';
sizesAndThemes.args = {};

const Template: Story<InputProps> = args => <Input {...args} />;

export const sandbox = Template.bind({});

sandbox.storyName = 'Sandbox';
sandbox.args = {};

export default csf;
