import { ForwardedRef, forwardRef } from 'react';
import clsx from 'clsx';

import type { InputProps } from './input.d';

export const Input = forwardRef(
    (
        { className, size = 'm', fullWidth, disabled, invalid, ...props }: InputProps,
        ref: ForwardedRef<HTMLInputElement>,
    ) => {
        return (
            <input
                {...props}
                ref={ref}
                aria-invalid={invalid}
                aria-disabled={disabled}
                disabled={disabled}
                className={clsx(
                    'input-base',
                    sizeClassName[size],
                    fullWidth && 'block w-full',
                    className,
                )}
            />
        );
    },
);

Input.displayName = 'Input';

const sizeClassName = {
    s: 'h-7 px-2 text-sm',
    m: 'h-9 px-2.5 text-sm',
    l: 'h-11 px-3 text-md',
};
