import clsx from 'clsx';

import type { ILabelProps } from './label.types';
import { Text } from '../../atoms';

// atomic:component:label
// atomic:component:label:type.function
export function Label({
    id,
    testId,
    className,
    children,
    size = 'sm',
    theme = 'primary',
}: ILabelProps) {
    return (
        <div
            id={id}
            data-qa={testId}
            className={clsx(
                'rounded-full inline-flex items-center justify-start',
                themes[theme],
                sizes[size],
                className,
            )}
        >
            <Text size={textType[size]} testId={testId && `${testId}-text`}>
                {children}
            </Text>
        </div>
    );
}

const themes = {
    primary: 'text-white bg-label-primary',
    secondary: 'text-white bg-label-secondary',
    attention: 'text-white bg-label-alert',
    neutral: 'text-grey-dark bg-label-neutral',
    active: 'text-grey-dark bg-label-active',
    light: 'text-grey-dark bg-label-light',
};

const sizes = {
    sm: 'h-4.5 px-2',
    md: 'h-5 px-2',
};

const textType = {
    sm: 'xs',
    md: 'sm',
} as const;
