import { TRangeValue } from './range.types';

export function normalizeRangeValue(
    [start, end]: TRangeValue,
    min: number,
    max: number,
): TRangeValue {
    const startInRange = Math.max(min, start);
    const endInRange = Math.min(max, end);

    return [startInRange > endInRange ? endInRange : startInRange, endInRange];
}
