import { Meta, Story } from '@storybook/react/types-6-0';
import { Range } from './range';
import type { IRangeProps, TRangeValue } from './range.types';
import { useState } from 'react';

const csf: Meta = {
    title: 'molecules/Range',
    component: Range,
};

export const gallery: Story<IRangeProps> = args => {
    // eslint-disable-next-line react-hooks/rules-of-hooks
    const [value, setValue] = useState<TRangeValue>([200, 1011]);

    return (
        <>
            <Range {...args} value={value} onChange={setValue} />
        </>
    );
};

gallery.storyName = 'Gallery';
gallery.args = {
    min: 100,
    max: 1350,
};

export default csf;
