import { Meta, Story } from '@storybook/react/types-6-0';
import { Fragment } from 'react';

import { Select } from './select';
import type { ISelectProps, TSelectSize, TSelectTheme } from './select.types';

const csf: Meta = {
    title: 'organisms/Select',
    component: Select,
};

const THEMES: TSelectTheme[] = ['secondary', 'outlined'];
const SIZES: TSelectSize[] = ['lg', 'md', 'sm'];

export const sizesAndThemes: Story<ISelectProps> = args => (
    <table className="text-left">
        <thead>
            <tr>
                <th className="p-4">Размер</th>
                {THEMES.map(theme => (
                    <th className="p-4" key={theme}>
                        {theme}
                    </th>
                ))}
            </tr>
        </thead>
        <tbody>
            {SIZES.map(size => (
                <tr key={size} className="border-b border-grey-light">
                    <td className="p-4">{size}</td>
                    {THEMES.map(theme => (
                        <td className="p-4" key={theme}>
                            <Select {...args} theme={theme} size={size} />
                        </td>
                    ))}
                </tr>
            ))}
        </tbody>
    </table>
);

sizesAndThemes.storyName = 'Размеры и темы';
sizesAndThemes.args = {
    placeholder: 'Выберите',
    data: [
        {
            value: 'foo',
            label: 'Цианид калия и счастье',
        },
        {
            value: 'bar',
            label: 'Метанол',
        },
        {
            value: 'baz',
            label: 'Батрахотоксин',
        },
    ],
};

export const states: Story<ISelectProps> = args => (
    <table className="text-left">
        <thead>
            <tr>
                <th className="p-4">Default</th>
                <th className="p-4">Invalid</th>
                <th className="p-4">Disabled</th>
            </tr>
        </thead>
        <tbody>
            {THEMES.map(theme => (
                <Fragment key={theme}>
                    <tr className="border-b border-grey-light" key={theme}>
                        <td className="p-4" key={theme}>
                            <Select {...args} theme={theme} />
                        </td>
                        <td className="p-4" key={theme}>
                            <Select {...args} theme={theme} invalid />
                        </td>
                        <td className="p-4" key={theme}>
                            <Select {...args} theme={theme} disabled />
                        </td>
                    </tr>
                    <tr className="border-b border-grey-light" key={theme}>
                        <td className="p-4" key={theme}>
                            <Select {...args} theme={theme} value="foo" />
                        </td>
                        <td className="p-4" key={theme}>
                            <Select {...args} theme={theme} value="foo" invalid />
                        </td>
                        <td className="p-4" key={theme}>
                            <Select {...args} theme={theme} value="foo" disabled />
                        </td>
                    </tr>
                </Fragment>
            ))}
        </tbody>
    </table>
);

states.storyName = 'Состояния';
states.args = sizesAndThemes.args;

const Template: Story<ISelectProps> = args => <Select {...args} />;

export const sandbox = Template.bind({});

sandbox.storyName = 'Sandbox';
sandbox.args = {};

export default csf;
