import { ReactElement } from 'react';

import type { ISharedHtmlAtomProps, PropsOf } from '../../types';

import { ButtonProps } from '../../molecules/button';

export type SelectComponent = (<Size extends TSelectSize = 'md'>(
    props: ISelectProps<Size>,
) => ReactElement) & {
    displayName?: string;
};

export interface ISelectProps<Size extends TSelectSize = 'md'>
    extends ISharedHtmlAtomProps,
        Pick<PropsOf<'input'>, 'name' | 'disabled' | 'autoFocus' | 'placeholder'>,
        Pick<PropsOf<'button'>, 'onFocus' | 'onBlur'>,
        Pick<ButtonProps<'button', Size>, 'textSize'> {
    data: ISelectOption[];
    value?: TSelectValue | null;
    invalid?: boolean;

    /**
     * Размер кнопки селекта
     */
    size?: Size;

    /**
     * Тема кнопки селекта
     */
    theme?: TSelectTheme;
    onChange?(value: TSelectValue): void;
}

export interface ISelectOption {
    value: TSelectValue;
    label?: string;
    disabled?: boolean;
}

export type TSelectSize = 'lg' | 'md' | 'sm';
export type TSelectTheme = 'outlined' | 'secondary';
export type TSelectValue = string | number;
