import { Meta } from '@storybook/react/types-6-0';

// @ts-ignore
import * as tailwind from '../tailwind.config';
import { Text } from '../atoms';

const csf: Meta = {
    title: 'theme/tailwind',
};

export const colors = () => <NestedColors record={tailwind.theme.colors} />;

colors.storyName = 'Цвета';
colors.args = {};

function NestedColors({
    nested,
    name,
    record,
}: {
    name?: string;
    record: Record<string, any>;
    nested?: boolean;
}) {
    const entries = Object.entries(record) as [string, string | Record<string, any>][];
    const globalColors = entries.filter(([_, value]) => typeof value === 'string');
    const nestedColors = entries.filter(([_, value]) => typeof value !== 'string');

    console.log({ name, nested, record, globalColors, nestedColors });

    return (
        <div className="space-y-4">
            <Text size={nested ? 'xl' : 'xxl'}>{name ?? 'Глобальные цвета'}</Text>
            <ColorsList entries={globalColors as any} name={name} />
            {nestedColors.map(([key, nestedRecord]) => (
                <NestedColors
                    key={key}
                    record={nestedRecord as any}
                    nested={nested || Boolean(name)}
                    name={name ? `${name}-${key}` : key}
                />
            ))}
        </div>
    );
}

function ColorsList({ entries, name }: { name?: string; entries: [string, string][] }) {
    return (
        <div
            className="grid grid-cols-4 md:grid-cols-8 lg:grid-cols-12 gap-4 p-4 overflow-hidden rounded-md"
            style={{
                backgroundSize: '20px 20px',
                backgroundPosition: '0 0, 0 10px, 10px -10px, -10px 0px',
                backgroundImage:
                    'linear-gradient(45deg, #ccc 25%, transparent 25%),linear-gradient(-45deg, #ccc 25%, transparent 25%),linear-gradient(45deg, transparent 75%, #ccc 75%),linear-gradient(-45deg, transparent 75%, #ccc 75%)',
            }}
        >
            {entries.map(([key, value]) => (
                <Color key={key} name={`${name ? name + '-' : ''}${key}`} value={value} />
            ))}
        </div>
    );
}

function Color({ value, name }: { value: string; name: string }) {
    return (
        <div className="rounded-md overflow-hidden border border-text-disabled">
            <div className="p-3 bg-white text-grey-dark border-b border-b-text-disabled">
                <Text size="md">{name}</Text>
            </div>
            <div
                className="h-16"
                style={{
                    backgroundColor: value,
                }}
            />
        </div>
    );
}

export default csf;
