/* eslint-disable @typescript-eslint/naming-convention */
import { YandexError } from '../shared';

export class BlackBoxError<
    Code extends string | number = BlackBoxErrorCode,
> extends YandexError<Code> {
    static isErrorResponse(value: any) {
        return value.exception;
    }
}

export class BlackBoxExceptionError extends BlackBoxError<BlackBoxExceptionCodeName> {
    static isException(value: any): value is BlackBoxFailedResponse {
        return 'exception' in value && 'error' in value;
    }

    static assert(response: any) {
        if (BlackBoxExceptionError.isException(response)) {
            throw new BlackBoxExceptionError(
                JSON.stringify(response, null, 2),
                // У нас есть ошибка, но OK
                response.exception.value === 'OK' ? 'UNKNOWN' : response.exception.value,
            );
        }
    }
}

export interface BlackBoxFailedResponse<
    T extends BlackBoxExceptionCodeName = BlackBoxExceptionCodeName,
> {
    exception: BlackBoxException<T>;
    error: string;
}

export interface BlackBoxException<T extends BlackBoxExceptionCodeName> {
    value: T;
    id: typeof BlackBoxExceptionCode[T];
}

export enum BlackBoxErrorCode {
    MISSED_SERVICE_TICKET = 'MISSED_SERVICE_TICKET',
    INVALID_REQUEST = 'INVALID_REQUEST',
}

/**
 * @see https://docs.yandex-team.ru/blackbox/concepts/blackboxErrors
 * @see https://a.yandex-team.ru/arc/trunk/arcadia/library/cpp/blackbox2/session_errors.h
 */
export type BlackBoxExceptionCodeName = keyof typeof BlackBoxExceptionCode;
export enum BlackBoxExceptionCode {
    OK = 0,
    UNKNOWN,
    INVALID_PARAMS,
    SECOND_INIT,
    BAD_COOKIE_SIZE,
    BAD_COOKIE_BODY,
    INVALID_SOURCE,
    BAD_COOKIE_TS,
    HOST_DONT_MATCH,
    DB_FETCHFAILED,
    DB_EXCEPTION,
    NO_DATA_KEYSPACE,
    KEYRING_FLOOD,
    BAD_KEY_ID,
    KEY_ID_FLOOD,
    KEY_NOT_FOUND,
    KEYSPACE_EMPTY,
    KEYSPACE_FAILED,
    BAD_SIGN,
    BAD_DATA_SIZE,
    BAD_DOMAIN_PREFIX,
    ACCESS_DENIED,
    CANT_CONNECT,
    VERSION_MISMATCH,
    GLOBALLY_LOGGED_OUT,
}
