/* eslint-disable @typescript-eslint/naming-convention */
import { YandexCookieName } from '../../shared';
import { BlackBoxAuthorizationStatus, BlackBoxCommonParams } from './common-params';

/**
 * @see https://docs.yandex-team.ru/blackbox/methods/sessionid
 */
export interface BlackBoxSessionIdParams extends BlackBoxSessionIdCommonParams {
    host: string;
    /**
     * IP-адрес пользователя.
     *
     * Указывается в стандартном формате IPv4 (например, 194.84.46.241) или IPv6 (например, 2001:0db8:11a3:09d7:1f34:8a2e:07a0:765d).
     * Получив IP-адрес в неверном формате, Черный ящик возвращает сообщение об ошибке.
     * Важно: для корректной работы метода нужно передавать настоящий IP пользователя.
     */
    userip: string;
    [YandexCookieName.SESSION_ID_SSL]?: string;
    [YandexCookieName.SESSION_ID]: string;
}

export interface BlackBoxSessionIdCommonParams extends BlackBoxCommonParams {
    /**
     * Признак запроса строки, идентифицирующей сессию.
     * Авторизационная кука содержит подстроку authid, которая не меняется при подновлении и редактировании куки.
     */
    authid?: boolean;
    /**
     * Позволяет получить данные об указанном аккаунте, даже если сессия не валидна, пользователь разлогинен или заблокирован.
     * Для кук с истекшим сроком действия информация не возвращается. Требует специального гранта.
     */
    full_info?: boolean;
    /**
     * Признак наличия в ответе User-тикета пользователя. User-тикет возвращается только если в запросе был Service-тикет,
     * переданный в заголовке X-Ya-Service-Ticket и проверка сессии прошла успешно.
     */
    get_user_ticket?: boolean;
    /**
     * @deprecated - TODO Добавить поддержку multisession
     *
     * Признак запроса информации обо всех аккаунтах, перечисленных в куке.
     *
     * Необходим сервисам, реализующим мультиавторизацию (переключение между несколькими аккаунтами,
     * с которыми пользователь вошел на Яндекс).
     *
     * Если параметр задан, ЧЯ включает в ответ данные обо всех перечисленных в куке аккаунтах.
     *
     * При этом при обработке ответа необходимо различать статус проверки куки, как контейнера для нескольких аккаунтов,
     * и статус проверки сессии для каждого из аккаунтов, т.к. статусы аккаунтов могут различаться.
     *
     * Если параметр не задан, возвращаются только данные и статус авторизации основного аккаунта — того,
     * на который пользователь переключился в последний раз.
     */
    multisession?: boolean;
    /**
     * Необязательный параметр для логирования. Значение, указанное в данном параметре, будет сохранено в statbox-логе в поле idnt.
     */
    statbox_id?: any;
    /**
     * Необязательный параметр для логирования. Значение, указанное в данном параметре, будет сохранено в statbox-логе в поле yuid.
     */
    yandexuid?: string;
}

export interface BlackBoxSessionIdResponse {
    status: BlackBoxAuthorizationStatus;
    user_ticket: string;
}
