import { BaseCommonConfig, BaseExtendConfig, ExtendedConfig, PartialFlat } from './types';

import { compactObject } from '../shared';

export function mergeConfig<Config extends BaseCommonConfig, Extend extends BaseExtendConfig>(
    config: ExtendedConfig<Config, Extend>,
    ...overrides: (PartialFlat<ExtendedConfig<Config, Extend>> | false | null)[]
): ExtendedConfig<Config, Extend> {
    for (const extended of overrides.filter(Boolean)) {
        for (const [name, value] of Object.entries(extended!) as [keyof Config, any][]) {
            if (typeof config[name] === 'object' && typeof value === 'object') {
                Object.assign(config[name], value);
            } else {
                config[name] = value;
            }
        }
    }

    return config;
}

export const getTvmEnvironmentConfig = () =>
    compactObject({
        url:
            process.env.TVM_DAEMON_ENDPOINT ??
            process.env.DEPLOY_TVM_TOOL_URL ??
            process.env.QLOUD_TVM_INTERFACE_ORIGIN,
        token: process.env.QLOUD_TVM_TOKEN ?? process.env.TVMTOOL_LOCAL_AUTHTOKEN,
    });
