/* eslint-disable @typescript-eslint/naming-convention */
import { TvmClientOptions } from '../tvm';
import { BlackBoxClientOptions } from '../blackbox';
import { IUatraitsHostParams } from '../uatraits';

export interface BaseCommonConfig<TvmDeps extends string = string> {
    tvm?: TvmClientOptions<TvmDeps>;
    uatrails?: IUatraitsHostParams;
    blackbox?: BlackBoxClientOptions<TvmDeps>;
}

export type ExtendedConfig<Config extends BaseCommonConfig, Extend extends BaseExtendConfig> = Omit<
    Extend,
    keyof Config
> &
    Config;

export type BaseExtendConfig = Record<string, any>;

export type PartialFlat<T extends Record<string, any>, Ignore extends boolean = false> = {
    [Key in keyof T]?: T[Key] extends Record<string, any>
        ? Ignore extends false
            ? PartialFlat<T[Key], true>
            : T[Key]
        : T[Key];
};
