// TODO Вынести в глобальные утилиты

import { Entries } from 'type-fest';

export const omit = <T extends Record<string, any>, K extends keyof T>(
    target: T,
    keys: K[],
): Omit<T, K> =>
    Object.fromEntries(
        (Object.entries(target) as Entries<T>).filter(([key]) => !keys.includes(key as K)),
    ) as T;

export const compactObject = <T extends Record<string, any>>(value: T): T =>
    Object.fromEntries(Object.entries(value).filter(([_, value]) => Boolean(value))) as T;
