export class YandexError<Code extends string | number> extends Error {
    readonly code: Code;
    readonly originalError?: Error;

    constructor(message: string, code: Code, error?: Error) {
        super(message);

        this.name = `Yandex:${this.constructor.name}`;
        this.code = code;

        if (error) {
            this.originalError = error;
            this.stack = `${this.stack}\n${error.stack}`;
        }
    }
}
