import { TvmErrorCode } from './types';

import { YandexError } from '../shared';

export class TvmError extends YandexError<TvmErrorCode> {}

export async function getTvmErrorFromFailedResponse(response: Response, name: string = 'unknown') {
    try {
        const text = await response.text();

        if (response.status === 400) {
            return new TvmError(
                `["${name}"] - invalid request because of "${text}"`,
                TvmErrorCode.INVALID_REQUEST,
            );
        }

        if (response.status === 401) {
            return new TvmError(
                `["${name}"] - invalid token ("${text}")`,
                TvmErrorCode.INVALID_TOKEN,
            );
        }
    } catch (e) {
        if (e instanceof Error) {
            return new TvmError(
                `[TVM - "${name}"] - unknown error - "${e.name}": "${e.message}"`,
                TvmErrorCode.REQUEST_ERROR,
                e,
            );
        }

        return new TvmError(JSON.stringify(e), TvmErrorCode.REQUEST_ERROR);
    }

    return null;
}
