import { IUatraits } from './types';

export function hasSameSiteSupport({
    SameSiteSupport,
    BrowserBase,
    BrowserBaseVersion,
}: IUatraits) {
    if (SameSiteSupport) return true;

    if (BrowserBase === 'Chromium' && BrowserBaseVersion) {
        const browserBaseVersionRound = parseInt(BrowserBaseVersion.split('.')[0], 10);

        return browserBaseVersionRound > 76;
    }

    return false;
}
