/* eslint-disable @typescript-eslint/naming-convention */

import { URLInit } from '../shared';

export interface IUatraitsHostParams {
    url?: URLInit;
}

export interface IUatralisOptionalHeaders {
    'x-wap-profile'?: string;
    'x-operamini-phone-ua'?: string;
    [key: string]: string | string[] | undefined;
}

/**
 * @see https://wiki.yandex-team.ru/Morda/browserDetect
 */
export interface IUatraits {
    x64: boolean;
    OSName: UatraitsOSName;
    OSFamily: UatraitsOSFamily;
    OSVersion: string;
    DeviceVendor?: UatraitsVendor;

    isBrowser: boolean;
    isMobile: boolean;
    preferMobile?: boolean;
    inAppBrowser?: boolean;
    isEmulator?: boolean;
    isTablet?: boolean;
    isRobot?: boolean;
    isBeta?: boolean;
    isWAP?: boolean;
    isTV?: boolean;

    // Ex "Chromium"
    BrowserBase?: string;
    BrowserBaseVersion?: string;
    BrowserName: UatraitsBrowserName;
    BrowserShell?: UatraitsBrowserShell;
    BrowserShellVersion?: string;
    BrowserEngine: UatraitsBrowserEngine;
    BrowserEngineVersion: string;
    BrowserVersion: string;

    SVGSupport: boolean;
    historySupport: boolean;
    postMessageSupport: boolean;
    localStorageSupport: boolean;
    SameSiteSupport: boolean;

    MailRuAgent?: boolean;
    MailRuAgentVersion?: string;
    MailRuSputnik?: boolean;

    YandexBar?: boolean;
    YandexBarVersion?: string;

    GoogleToolBar?: boolean;
    GoogleToolBarVersion?: string;
}

export type UatraitsBrowserEngine =
    | 'Gecko'
    | 'KHTML'
    | 'Presto'
    | 'Proprietary'
    | 'TextBased'
    | 'Trident'
    | 'UCBrowser'
    | 'Unknown'
    | 'WebKit';

export type UatraitsBrowserName =
    | 'AdobeAIR'
    | 'AndroidBrowser'
    | 'Arora'
    | 'AvantBrowser'
    | 'BlackBerry'
    | 'Blackberry'
    | 'Blazer'
    | 'Camino'
    | 'Chrome'
    | 'ChromeMobile'
    | 'Chromium'
    | 'Dalvik'
    | 'Docomo'
    | 'Dolfin'
    | 'Dolphin'
    | 'Edge'
    | 'ELinks'
    | 'Epiphany'
    | 'Firefox'
    | 'Flock'
    | 'Galeon'
    | 'IEMobile'
    | 'Jasmine'
    | 'K-Meleon'
    | 'Konqueror'
    | 'LGBrowser'
    | 'Links'
    | 'Lynx'
    | 'MQQBrowser'
    | 'MSIE'
    | 'Maxthon'
    | 'Mercury'
    | 'Midori'
    | 'Minimo'
    | 'MobileFirefox'
    | 'MobileSafari'
    | 'Mozilla'
    | 'NetFront'
    | 'NetFrontLifeBrowser'
    | 'NetSurf'
    | 'Netscape'
    | 'Ninesky'
    | 'NokiaBrowser'
    | 'Obigo'
    | 'OmniWeb'
    | 'OpenWave'
    | 'Opera'
    | 'OperaMini'
    | 'OperaMobile'
    | 'OviBrowser'
    | 'PaleMoon'
    | 'Polaris'
    | 'QtWeb'
    | 'QupZilla'
    | 'Rekonq'
    | 'SEMC'
    | 'Safari'
    | 'SeaMonkey'
    | 'SkyFire'
    | 'UCBrowser'
    | 'Unknown'
    | 'WebOSBrowser'
    | 'YandexBrowser'
    | 'YandexInternet'
    | 'iTunes';

export type UatraitsBrowserShell =
    | 'AvantBrowser'
    | 'Diigo'
    | 'GreenBrowser'
    | 'Maxthon'
    | 'MicrosoftOffice'
    | 'MyIE'
    | 'MyIE2'
    | 'NetCaptor'
    | 'SlimBrowser'
    | 'UCBrowser'
    | 'iCab';

export type UatraitsOSFamily =
    | 'AIX'
    | 'Android'
    | 'BREW'
    | 'Bada'
    | 'BlackBerry'
    | 'ChromeOS'
    | 'FreeBSD'
    | 'HP-UX'
    | 'IRIX'
    | 'Java'
    | 'Linux'
    | 'MacOS'
    | 'MeeGo'
    | 'NetBSD'
    | 'Nucleus'
    | 'OS/2'
    | 'OpenBSD'
    | 'QNX'
    | 'RIMTabletOS'
    | 'Series40'
    | 'SunOS'
    | 'Symbian'
    | 'UNIX'
    | 'Unknown'
    | 'UnknownNix'
    | 'WebOS'
    | 'Windows'
    | 'WindowsMobile'
    | 'WindowsPhone'
    | 'iOS';

export type UatraitsOSName =
    | 'ALTLinux'
    | 'ASPLinux'
    | 'Android Astro'
    | 'Android Bender'
    | 'Android Cupcake'
    | 'Android Donut'
    | 'Android Eclair'
    | 'Android Froyo'
    | 'Android Gingerbread'
    | 'Android Honeycomb'
    | 'Android Ice Cream Sandwich'
    | 'Android Jelly Bean'
    | 'CentOS'
    | 'Debian'
    | 'Fedora'
    | 'Gentoo'
    | 'Mac OS X Leopard'
    | 'Mac OS X Lion'
    | 'Mac OS X Mountain Lion'
    | 'Mac OS X Snow Leopard'
    | 'Mac OS X Tiger'
    | 'Mandriva'
    | 'Mint'
    | 'RedHat'
    | 'SUSE'
    | 'SplashTop'
    | 'Ubuntu'
    | 'Windows 2000'
    | 'Windows 3.11'
    | 'Windows 7'
    | 'Windows 8'
    | 'Windows 95'
    | 'Windows 98'
    | 'Windows ME'
    | 'Windows NT 4.0'
    | 'Windows Server 2003'
    | 'Windows Vista'
    | 'Windows XP';

export type UatraitsVendor =
    | 'Apple'
    | 'HP'
    | 'HTC'
    | 'Huawei'
    | 'LG Electronics'
    | 'Nokia'
    | 'RIM'
    | 'SAMSUNG'
    | 'Samsung'
    | 'Sony'
    | 'Sony Ericsson';
