import { IUatraitsHostParams, IUatralisOptionalHeaders } from './types';

import { YandexHeaderName } from '../shared';

export class UatraitsClient {
    static defaultUrl = 'http://uatraits.qloud.yandex.ru';

    private readonly url: URL;

    constructor({ url = UatraitsClient.defaultUrl }: IUatraitsHostParams) {
        this.url = new URL('/v0/detect', url);
    }

    async get(userAgent: string, optionalHeaders: IUatralisOptionalHeaders = {}) {
        const headers = Object.fromEntries(
            Object.entries(optionalHeaders)
                .map(([name, value]) => [SUPPORTED_HEADERS[name.toLowerCase()], value])
                .filter(([name, value]) => name && value),
        );

        const response = await fetch(this.url.toString(), {
            method: 'POST',
            body: JSON.stringify({
                [YandexHeaderName.USER_AGENT]: userAgent,
                ...headers,
            }),
        });

        if (!response.ok) {
            throw new Error(response.statusText);
        }

        return response.json();
    }
}

const SUPPORTED_HEADERS: Record<string, string> = {
    'x-wap-profile': 'X-Wap-Profile',
    'x-operamini-phone-ua': 'X-Operamini-Phone-Ua',
};
