import { RequestHandler } from 'express';

import { ITvmParams, TTvmResult, TvmClient } from '../core/tvm';

export function expressTvmMiddleware({
    clientId,
    throwError = true,
    ...params
}: IExpressTvmParams): RequestHandler {
    const tvm = new TvmClient({
        ...params,
    });

    return (req, _res, next) => {
        tvm.getTickets()
            .then(tickets => {
                req.tvm = req.tvm ?? {};
                req.tvm[clientId] = Object.fromEntries(
                    tickets.asList.map(ticket => [ticket.name, ticket.original]),
                );
            })
            .catch(error => {
                if (throwError) {
                    next(error);
                }

                req.tvm = req.tvm ?? {};
                req.tvm[clientId] = {
                    ...req.tvm[clientId],
                    error,
                };
            });
    };
}

declare global {
    // eslint-disable-next-line @typescript-eslint/no-namespace
    namespace Express {
        // eslint-disable-next-line @typescript-eslint/naming-convention
        interface Request {
            tvm?: Record<
                string,
                {
                    tickets: TTvmResult<any>;
                    error?: any;
                }
            >;
        }
    }
}

export interface IExpressTvmParams extends ITvmParams<any> {
    /**
     * ID вашего TVM-приложения
     */
    clientId: string | number;
    throwError?: boolean;
}
