import { RequestHandler } from 'express';
// @ts-expect-error no types
import getLocalUatraits from 'yandex-useragent';

import { IUatraitsHostParams } from '../core/uatraits/types';

import { IUatraits, UatraitsClient } from '../core/uatraits';

export function expressUatraitsMiddleware({
    server,
    url = server,
}: IExpressUatraitsParams = {}): RequestHandler {
    const uatraitsClient = new UatraitsClient({ url });

    return (req, _res, next) => {
        const userAgent = req.headers['user-agent'] as string;

        if (!userAgent) {
            req.uatraits = {} as IUatraits;

            next();
        }

        if (req.uatraits) next();

        uatraitsClient
            .get(userAgent, req.headers)
            .catch(error => ({
                ...getLocalUatraits(userAgent),
                fallback: true,
                error,
            }))
            .then(uatraits => {
                req.uatraits = uatraits;
                next();
            });
    };
}

declare global {
    // eslint-disable-next-line @typescript-eslint/no-namespace
    namespace Express {
        // eslint-disable-next-line @typescript-eslint/naming-convention
        interface Request {
            uatraits?: IUatraits;
        }
    }
}

export interface IExpressUatraitsParams extends IUatraitsHostParams {
    /**
     * @deprecated
     */
    server?: URL | string;
}
