import { RequestHandler } from 'express-serve-static-core';

import {
    createYandexUid,
    createYandexUidCookieParams,
    getYandexUidDomain,
    isValidYandexUid,
    isYandexUidSupported,
} from '../core/yandexuid';
import { YandexCookieName } from '../core/shared';

export function expressYandexUidMiddleware(): RequestHandler {
    return (req, res, next) => {
        if (!req.cookies) {
            return next(new Error('cookie-parser middleware is not installed'));
        }

        if (isValidYandexUid(req.cookies[YandexCookieName.YANDEX_UID] ?? '')) {
            next();
        }

        if (!req.uatraits) {
            return next(new Error('uatraits middleware is not installed'));
        }

        const domain = getYandexUidDomain(req.hostname)!;

        if (
            !isYandexUidSupported({
                method: req.method,
                domain,
                uatraits: req.uatraits,
            })
        ) {
            next();
        }

        res.cookie(
            YandexCookieName.YANDEX_UID,
            createYandexUid(),
            createYandexUidCookieParams({
                uatraits: req.uatraits,
                domain,
            }),
        );
        next();
    };
}
