import { NextRequest, NextResponse } from 'next/server';
import { v4 } from 'uuid';

import { YandexCookieName } from '../../core/shared';

export function addYandexSessionIdCookie(
    req: NextRequest,
    res: NextResponse,
    cookieName: string = YandexCookieName.DEFAULT_SESSION_KEY,
) {
    if (!req.cookies.has(cookieName)) {
        res.cookies.set(cookieName, v4(), {
            path: '/',
            httpOnly: true,
        });
    }
}
