import { NextRequest, NextResponse } from 'next/server';

import { IUatraits } from '../../core/uatraits';
import {
    createYandexUid,
    createYandexUidCookieParams,
    getYandexUidDomain,
    isValidYandexUid,
    isYandexUidSupported,
} from '../../core/yandexuid';
import { YandexCookieName } from '../../core/shared';
import { isCookieAllowed } from './is-cookie-allowed';

export function addYandexUidCookie(req: NextRequest, res: NextResponse, uatraits: IUatraits) {
    const domain = getYandexUidDomain(req.nextUrl.href)!;
    const yandexuid = req.cookies.get(YandexCookieName.YANDEX_UID) ?? '';

    if (
        !isValidYandexUid(yandexuid) &&
        isCookieAllowed(req) &&
        isYandexUidSupported({
            domain,
            method: req.method,
            uatraits,
        })
    ) {
        res.cookies.set(
            YandexCookieName.YANDEX_UID,
            createYandexUid(),
            createYandexUidCookieParams({
                uatraits,
                domain,
            }),
        );
    }
}
