import { NextRequest } from 'next/server';

import { YandexCookieName } from '../../core/shared';

export function isNextMiddlewareAuthorized(req: NextRequest) {
    // TODO Добавить возможность проверить TVM и BlackBox
    return hasNextMiddlewareAuthCookie(req);
}

export const hasNextMiddlewareAuthCookie = (req: NextRequest) =>
    req.cookies.has(YandexCookieName.YANDEX_UID) && req.cookies.has(YandexCookieName.SESSION_ID);
