import { NextRequest } from 'next/server';

import { isCookieAllowedValue, YandexQueryName } from '../../core/shared';

export const isCookieAllowed = (req: NextRequest) =>
    isCookieAllowedValue(req.nextUrl.searchParams.get(YandexQueryName.NO_COOKIE_SUPPORT));
