import { NextRequest } from 'next/server';
import { Logger } from 'logger';
import { secureCookie, secureHeaders } from 'logger/middlewares/secure';

export function getNextMiddlewareLogger(req: NextRequest, parent: Logger = Logger.default): Logger {
    return parent.child(
        {
            name: `${parent.fields.name}.next-middleware`,
            hostname: req.nextUrl.hostname,
            requestId: getMiddlewareRequestId(req),
            req: {
                cookies: req.cookies,
                method: req.method,
                url: req.nextUrl.toString(),
                headers: Object.fromEntries(req.headers.entries()),
                body: req.body,
                remoteAddress: getMiddlewareRemoteAddress(req),
            },
        },
        {
            middlewares: [secureCookie(), secureHeaders()],
        },
    );
}

const getMiddlewareRequestId = ({ headers }: NextRequest) =>
    headers.has('x-request-id')
        ? headers.get('x-request-id')
        : headers.has('x-req-id')
        ? headers.get('x-req-id')
        : undefined;

const getMiddlewareRemoteAddress = ({ headers }: NextRequest) => headers.get('x-real-ip');
