import { NextRequest } from 'next/server';

export const getMiddlewareRequestId = ({ headers }: NextRequest) =>
    headers.has('x-request-id')
        ? headers.get('x-request-id')
        : headers.has('x-req-id')
        ? headers.get('x-req-id')
        : undefined;

export const getMiddlewareRemoteAddress = ({ headers }: NextRequest) => headers.get('x-real-ip');
