#!/usr/bin/env node

import { getChangesWithInfo } from './lib/arc.mjs';
import { Cli, Command, Option } from 'clipanion';

process.removeAllListeners('warning');
process.env.NODE_NO_WARNINGS = '1';

class ChangesCommand extends Command {
    static paths = [['arc', 'changes']];

    files = Option.Boolean('--files', false);
    packages = Option.Boolean('--packages', false);
    inline = Option.Boolean('--inline');
    staged = Option.Boolean('--staged', false);
    base = Option.String('--base');
    head = Option.String('--head');

    async execute() {
        const {
            changes: { packages, files },
        } = await getChangesWithInfo({
            base: this.base,
            head: this.head,
            staged: this.staged,
        });
        const packagesNames = packages.map(item => item.name);

        if (this.files) {
            return this.writeAsList(files);
        }
        if (this.packages) {
            return this.writeAsList(packagesNames);
        }
        this.context.stdout.write(`Changed packages: ${packagesNames.join(', ')}\n`);
        this.context.stdout.write(`Changed files:\n  ${files.join('\n  ')}\n`);
    }

    writeAsList(value) {
        this.context.stdout.write(value.join(this.inline ? ',' : '\n'));
    }
}

const cli = new Cli({
    binaryName: `ci`,
    binaryLabel: `CI Utils`,
    binaryVersion: `0.0.1`,
});

cli.register(ChangesCommand);
cli.runExit(cli.process(process.argv.slice(2)));
