import { execSync } from 'node:child_process';

export class ArcClient {
    getRoot() {
        return execAndParse('arc root').toString();
    }

    getDiff({ cached, staged, base, head, git = true, nameOnly, status }) {
        const [{ names }] = JSON.parse(
            execSync(
                [
                    'arc diff',
                    nameOnly && '--json --name-only',
                    nameOnly && status && '--name-status',
                    cached && '--cached',
                    staged && '--staged',
                    git && '--git',
                    !staged && !cached && base,
                    !staged && !cached && head,
                ]
                    .filter(Boolean)
                    .join(' '),
                {
                    stdio: 'pipe',
                },
            ).toString('utf-8'),
        );

        return names;
    }
}

export const arc = new ArcClient();

const execAndParse = (command, options = {}) =>
    parseOutputAsLinesList(
        execSync(command, {
            stdio: 'pipe',
            ...options,
        }),
    );
const parseOutputAsLinesList = output =>
    output
        .toString('utf-8')
        .split('\n')
        .map(a => a.trim())
        .filter(a => a.length > 0);
