import { readdir } from 'fs/promises';
import { dirname } from 'path';

export class WorkspaceClient {
    getRoot() {
        return getWorkspaceRootPath(process.cwd());
    }
}

export const workspace = new WorkspaceClient();

async function getWorkspaceRootPath(path) {
    const items = await readdir(path);

    return items.includes('yarn.lock') ? path : getWorkspaceRootPath(dirname(path));
}
