#include <travel/hotels/boiler/service/service.h>
#include <travel/hotels/boiler/proto/config.pb.h>

#include <travel/hotels/lib/cpp/yt/tools.h>
#include <travel/hotels/lib/cpp/protobuf/config.h>
#include <travel/hotels/lib/cpp/protobuf/tools.h>
#include <travel/hotels/lib/cpp/util/profiletimer.h>
#include <travel/hotels/lib/cpp/util/signals.h>

#include <library/cpp/getopt/opt.h>
#include <library/cpp/logger/global/global.h>
#include <library/cpp/sighandler/async_signals_handler.h>
#include <library/cpp/svnversion/svnversion.h>

int main(int argc, const char* argv[]) {
    NTravel::TProfileTimer::Init();
    SetupSignalHandlers();
    InitGlobalLog2Console(TLOG_INFO);
    TString configDir, env, ytTokenPath, ypTokenPath;
    bool dbg;
    {
        NLastGetopt::TOpts opts;
        opts.AddHelpOption('h');
        opts.AddLongOption('c', "config-dir", "Path to config dir")
            .Required()
            .StoreResult(&configDir);
        opts.AddLongOption('e', "env", "Environment")
            .StoreResult(&env)
            .DefaultValue("dev");
        opts.AddLongOption('t', "yt-token-path", "Yt TokenPath")
            .StoreResult(&ytTokenPath);
        opts.AddLongOption('p', "yp-token-path", "Yp TokenPath")
            .StoreResult(&ypTokenPath);
        opts.AddLongOption('d', "debug", "Enable debug log")
            .SetFlag(&dbg).NoArgument();
        NLastGetopt::TOptsParseResult res(&opts, argc, argv);
    }
    TFsPath configPath(configDir);
    //-------- Read service config
    auto pbCfg = NTravel::ReadAppConfigWithSubstitutions<NTravelProto::NBoiler::TConfig>("boiler", configPath, env, ytTokenPath, ypTokenPath);

    DoInitGlobalLog(CreateLogBackend(pbCfg.GetOther().GetMainLogFile(), dbg ? TLOG_DEBUG : TLOG_INFO, true));

    INFO_LOG << "Starting Boiler revision " << GetProgramSvnRevision() << ", built on " << GetProgramBuildDate() << Endl;

    NTravel::NYtRpc::Init();

    {
        NTravel::TService service(pbCfg, env);
        for (int signal: {SIGINT, SIGTERM}) {
            SetAsyncSignalFunction(signal, [&service](int) {
                service.Stop();
            });
        }

        service.Run();
    }
    NTravel::NYtRpc::Shutdown();

    INFO_LOG << "Shutdown finished" << Endl;
    return 0;
}
