#pragma once

#include "data.h"

#include <travel/hotels/lib/cpp/data/data.h>

#include <util/generic/ptr.h>

namespace NTravel {
namespace NBoiler {

constexpr double g_Alpha = 0.9997;

enum class EKeyState {
    Inexistent,
    Existent,
    ExistentError,
    InexistentBoiled
};

struct TKeyUsage {
    TKeyUsage();

    void AddUsage(TInstant ts, double value, TInstant castTs);
    void AddUsage(const TKeyUsage& rhs, int coef, TInstant castTs);
    void Recast(TInstant castTs);
    void Clear();

    double GetCastedTo(TInstant ts) const;
    double GetCasted() const;
    TInstant GetUpdateTs() const;
private:
    TInstant UpdateTs;     // Время, когда обновлялся Usages
    double   Usages ;      // Затухающее использование
    double   UsagesCasted; // Использование, скастованное на время castTs
};

struct TKeyInfo {
    TKeyUsage Usage;

    EKeyState  State;
    TInstant   Ts;       // Timestamp последнего события из шины OfferBus про ключ, для дедупликации
    TInstant   ExpireTs; // Когда закончится пребывание в Existent или InexistentBoiled
    TPermalink Permalink = 0;
    bool       IsGreylisted = false;
    bool       AllowDateShift = false;

    void UpdatePermalink(TPermalink permalink);
    bool IsBoilable() const;

    size_t CalcTotalByteSize() const;
};

struct TBoilableKeyInfo {
    // Все usage кастуем к единому времени, и приводим к целому, чтобы легко было сравнивать и можно было хранить в set
    // Периодически (раз в сутки) меняем время, к которому кастуем, чтобы кастовать не слишком далеко
    const i64       UsageCasted;
    const TKey      Key;

    bool operator < (const TBoilableKeyInfo& rhs) const;
    static TBoilableKeyInfo FromKeyInfo(const TKey& key, const TKeyInfo& info);

    size_t CalcTotalByteSize() const;
};

struct TBoilingThreshold {
    void Update(double value);

    double GetValue();

    static const double Lambda;
    static const double NegativeInfinity;

private:
    bool IsInited = false;
    double Value;
};

}// namespace NBoiler
}// namespace NTravel
