#include "data.h"

#include <travel/hotels/lib/cpp/util/sizes.h>

#include <util/digest/multi.h>
#include <math.h>

namespace NTravel {

bool TKey::operator == (const TKey& rhs) const {
    return Currency == rhs.Currency &&
            HotelId == rhs.HotelId &&
            DateIn == rhs.DateIn &&
            DateOut == rhs.DateOut &&
            Occupancy == rhs.Occupancy;
}

bool TKey::operator <  (const TKey& rhs) const {
    if (Currency != rhs.Currency) {
        return Currency < rhs.Currency;
    }
    if (HotelId != rhs.HotelId) {
        return HotelId < rhs.HotelId;
    }
    if (DateIn != rhs.DateIn) {
        return DateIn < rhs.DateIn;
    }
    if (DateOut != rhs.DateOut) {
        return DateOut < rhs.DateOut;
    }
    if (Occupancy.GetAdultCount() != rhs.Occupancy.GetAdultCount()) {
        return Occupancy.GetAdultCount() < rhs.Occupancy.GetAdultCount();
    }
    return Occupancy.GetChildrenAges() < rhs.Occupancy.GetChildrenAges();
}

size_t TKey::Hash() const {
    return MultiHash(Currency, HotelId, DateIn, DateOut, Occupancy);
}

size_t TKey::CalcTotalByteSize() const {
    return sizeof(TKey) + TTotalByteSize<THotelId>()(HotelId) - sizeof(THotelId);
}

}// namespace NTravel

template <>
void Out<NTravel::TKey>(IOutputStream& out, const NTravel::TKey& key) {
    out << key.Currency << "/" << key.HotelId.ToCompositeString()
        << "/" << key.DateIn << "/" << key.DateOut << "/" << key.Occupancy;
}


template <>
void Out<NTravel::TAges>(IOutputStream& out, const NTravel::TAges& ages) {
    out << ages.ToOccupancyString();
}
