#include "greylist.h"

namespace NTravel {

    TGreylist::TGreylist(const NTravelProto::NAppConfig::TYtTableCacheConfig& greylistTable)
        : TableCache_("HotelsGreylist", greylistTable)
    {
        auto conv = [](const NYT::TNode& node, NTravelProto::THotelIdWithPermalink* proto) {
            auto& hotelId = *proto->MutableHotelId();
            hotelId.SetPartnerId(ExtractPartnerIdFromYtRow(node));
            hotelId.SetOriginalId(ExtractOriginalIdFromYtRow(node));
            proto->SetPermalink(ExtractPermalinkFromYtRow(node));
        };
        auto data = [this](const NTravelProto::THotelIdWithPermalink& proto) {
            NewGreylist_.emplace(proto.GetPermalink(), THotelId{proto.GetHotelId().GetPartnerId(), proto.GetHotelId().GetOriginalId()});
        };
        auto finish = [this](bool ok, bool /*initial*/) {
            if (ok) {
                TWriteGuard g(GreylistLock_);
                swap(NewGreylist_, Greylist_);
            }
            NewGreylist_.clear();
        };
        TableCache_.SetCallbacks(conv, data, finish);
    }

    bool TGreylist::IsGreylisted(TPermalink permalink, const THotelId& hotelId) {
        TReadGuard g(GreylistLock_);
        return Greylist_.contains(std::make_pair(permalink, hotelId));
    }

    void TGreylist::RegisterCounters(NMonitor::TCounterSource& source, const TString& name) {
        TableCache_.RegisterCounters(source, name);
    }

    void TGreylist::Start() {
        TableCache_.Start();
    }

    void TGreylist::Stop() {
        TableCache_.Stop();
    }

    bool TGreylist::IsReady() const {
        return TableCache_.IsReady();
    }
}
