#pragma once

#include "data.h"

#include <travel/hotels/boiler/proto/config.pb.h>
#include <travel/hotels/proto2/bus_messages.pb.h>
#include <travel/hotels/proto2/hotels.pb.h>

#include <travel/hotels/lib/cpp/mon/counter.h>
#include <travel/hotels/lib/cpp/mon/counter_hypercube.h>
#include <travel/hotels/lib/cpp/mon/tools.h>
#include <travel/hotels/lib/cpp/yt/table_cache.h>
#include <travel/hotels/lib/cpp/yt/queue_writer.h>
#include <travel/hotels/lib/cpp/util/flag.h>

#include <util/thread/factory.h>
#include <util/generic/hash.h>
#include <util/generic/hash_set.h>
#include <util/generic/map.h>
#include <util/generic/vector.h>
#include <util/generic/ptr.h>
#include <library/cpp/deprecated/atomic/atomic.h>
#include <util/system/event.h>
#include <util/system/mutex.h>

namespace NTravel {
    class TGreylist {
    public:
        explicit TGreylist(const NTravelProto::NAppConfig::TYtTableCacheConfig& greylistTable);
        bool IsGreylisted(TPermalink permalink, const THotelId& hotelId);
        void RegisterCounters(NMonitor::TCounterSource& source, const TString& name);
        void Start();
        void Stop();
        bool IsReady() const;

    private:
        TYtTableCache<NTravelProto::THotelIdWithPermalink> TableCache_;

        TRWMutex GreylistLock_;
        THashSet<std::pair<TPermalink, THotelId>> Greylist_;

        THashSet<std::pair<TPermalink, THotelId>> NewGreylist_;
    };
}
