#pragma once

#include "data.h"

#include <travel/hotels/boiler/proto/config.pb.h>
#include <travel/hotels/proto/offercache_grpc/offercache_service.grpc.pb.h>

#include <travel/hotels/lib/cpp/grpc/grpc_async_client.h>
#include <travel/hotels/lib/cpp/util/flag.h>
#include <travel/hotels/lib/cpp/mon/counter.h>
#include <travel/hotels/lib/cpp/yp_auto_resolver/yp_auto_resolver.h>

#include <util/generic/vector.h>
#include <util/generic/deque.h>
#include <util/thread/factory.h>
#include <library/cpp/deprecated/atomic/atomic.h>
#include <util/system/event.h>
#include <util/system/mutex.h>

namespace NTravel {

class TSender : public IThreadFactory::IThreadAble {
public:
    TSender(const NTravelProto::NAppConfig::TConfigGrpcClient& offerCacheCfg, const NTravelProto::NBoiler::TConfig::TSender& senderCfg);
    ~TSender();

    void RegisterCounters(NMonitor::TCounterSource& counters);

    void Start();
    void Stop();

    TString GetOfferCacheClientId(const TString& client, const TString& clientSuffix) const;

    void Send(const TKey& key, TPermalink permalink, const TString& client, const TString& clientSuffix, const TString& comment);
private:
    struct TCounters : public NMonitor::TCounterSource {
        NMonitor::TCounter      NotEnabled;
        NMonitor::TDerivCounter NGrpcErrors;
        NMonitor::TDerivCounter NSubRespErrors;

        void QueryCounters(NMonitor::TCounterTable* ct) const override;
    };

    struct TSendItem {
        TKey       Key;
        TPermalink Permalink;
        TString    Client;
        TString    ClientSuffix;
        TString    Comment;
    };

    const size_t SendDelaySec_;

    THashMap<TString, size_t> ClientSendDelaySec_;

    TMutex YpLock_;
    size_t SendMaxDelaySec_;
    size_t SendOffsetSec_;
    bool Enabled_;


    TCounters Counters_;

    TYpAutoResolver YpAutoResolver_;

    using TOfferCacheGrpcClient = NGrpc::TAsyncClient<NTravelProto::NOfferCacheGrpc::OfferCacheServiceV1>;
    TOfferCacheGrpcClient OfferCacheClient_;

    TAutoPtr<IThreadFactory::IThread> Thread_;
    TAtomicFlag StopFlag_;
    TAutoEvent WakeUp_;

    TMutex QueueLock_;
    TDeque<TVector<TSendItem>> SendQueue_;

    void DoExecute() override;
    void DoSend();
    void UpdateHosts(const TVector<TString>& hosts);
};

}// namespace NTravel
